<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ProductRate extends Model 
{

    protected $table = 'product_rates';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('client_id', 'product_id', 'rate');

    public function product()
    {
        return $this->belongsTo('App\Models\Product');
    }

}